﻿###########################################################
# visuaFUSION Systems Solutions
# Computer Info Installation Script
# Script By: Sean Huggans
###########################################################
# Script Variables
##########################
$AppName = "Computer Info"
$Version = "21.3.4.7"
$LogFile = "install.log"
$AppInstallerFile = "visuaFUSIONComputerInfo.msi" #name of the app installation file
$LogoFile = "CompanyLogo.png"
$LogDir = "C:\Windows\Logs\Software\$($AppName)"
$LogPath = "$($LogDir)\$($LogFile)"
if (Test-Path "C:\Program Files (x86)") {
    $InstallationPath = "C:\Program Files (x86)\visuaFUSION\Computer Info"
} else {
    $InstallationPath = "C:\Program Files\visuaFUSION\Computer Info"
}
$TotalSoftware = new-object System.Collections.ArrayList
$TotalSoftwareList = new-object System.Collections.ArrayList
$RegPathList = New-Object System.Collections.ArrayList

##########################
# Script Functions
##########################

function Log-Action ($Message, $StampDateTime)
{
    ################################
    # Function Version 18.4.14.1
    # Function by Sean Huggans
    ################################
	New-Item -ItemType directory -Path $LogDir -Confirm:$false -Force | out-null
    if (($StampDateTime -eq $false) -or ($StampDateTime -eq "no")) {
        $Message | Out-File $LogPath -Append
    } else {
	    "[ $(get-date -Format 'yyyy.MM.dd HH:mm:ss') ] $($Message)" | Out-File $LogPath -Append
    }
}

function Install-AppMSI ($MSIFile) {
    Log-Action -Message "Installing ""$($MSIFile)"", See resulting MSI log for specific details..."
    $InstallerFilePath = "$($PSScriptRoot)\$($MSIFile)"
    if (Test-Path -Path $InstallerFilePath) {
        try {
            foreach ($InstalledVersion in $TotalSoftware) {
                Try {
                    # Uninstall Previous Version - we can't change product code in MSI without breaking taskbar pins common with this app!  In this case, once users log off and back on, StartLayoutModification xml will rebuild broken shortcuts.
                    $UnInstallProccess = Start-Process -FilePath msiexec -ArgumentList "/x""$($InstalledVersion.ObjectName)"" /qn /l*v ""$($LogDir)\$($MSIFile.Replace(".","-"))-Uninstall-$($InstalledVersion.ObjectName.Replace('{','').Replace('}','')).log""" -Wait -PassThru -NoNewWindow
                    if ($UnInstallProccess.ExitCode -eq 0) {
                        Log-Action -Message "UnInstalling ""$($InstalledVersion.DisplayName) $($InstalledVersion.Version)"": Success (Exit Code: $($InstallProccess.ExitCode))"
                    } else {
                        Log-Action -Message "UnInstalling ""$($InstalledVersion.DisplayName) $($InstalledVersion.Version)"": Failed (Exit Code: $($InstallProccess.ExitCode)) - Installation of new version will abort!"
                        return $False
                    }
                } catch {
                    Log-Action -Message "UnInstalling ""$($InstalledVersion.DisplayName) $($InstalledVersion.Version)"": Error! Error Launching UnInstall - Installation of new version will abort!"
                    return $False
                }
            }
            Log-Action -Message "Beginning installation of packaged version..."
            $InstallProccess = Start-Process -FilePath msiexec -ArgumentList "/i ""$($InstallerFilePath)"" /qn /l*v ""$($LogDir)\$($MSIFile.Replace(".","-"))-Install.log""" -Wait -PassThru -NoNewWindow
            if ($InstallProccess.ExitCode -eq 0) {
                Log-Action -Message "Installing ""$($MSIFile)"": Success (Exit Code: $($InstallProccess.ExitCode))"
                return $true
            } else {
                Log-Action -Message "Installing ""$($MSIFile)"": Failed (Exit Code: $($InstallProccess.ExitCode))"
                return $False
            }
        } catch {
            Log-Action -Message "Installing ""$($MSIFile)"": Error! Error Launching Install"
            return $False
        }
    } else {
        Log-Action -Message "Installing ""$($MSIFile)"": Error! Installer file is not present in the package!"
        return $False
    }
}

function Install-ComputerInfoLogo ($CompanyLogoFile) {
    $LogoFilePath = "$($PSScriptRoot)\$($CompanyLogoFile)"
    if (Test-Path -Path $LogoFilePath) {
        if ($(Get-ItemProperty -Path $LogoFilePath).Extension.ToUpper() -eq ".PNG") {
            try {
                Copy-Item -Path $LogoFilePath -Destination "$($InstallationPath)\CompanyLogo.png" -Force -confirm:$False -ErrorAction Stop | Out-Null
                Log-Action -Message "Company Logo image ($($CompanyLogoFile)), installed successfully!"
                return $true
            } catch {
                Log-Action -Message "failed to copy the Company Logo image file ($($CompanyLogoFile)) to the installation directory!"
                return $False
            }
        } else {
            Log-Action -Message "The provided Company Logo image file ($($CompanyLogoFile)) is not PNG format!"
            return $False
        }
    } else {
        Log-Action -Message "The provided Company Logo image file ($($CompanyLogoFile)) is not present in the package!"
        return $False
    }
}

##########################
# Execution Logic
##########################

Log-Action -Message "=================================================================================================" -StampDateTime $False
Log-Action -Message "= $($AppName) Installation | Installation Script Version: $($Version)" -StampDateTime $False
Log-Action -Message "=================================================================================================" -StampDateTime $False
Log-Action -Message "Installation script started..."

# Get list of installed software (needed for uninstall of previous versions)
# Evaluate Registry for installed software
$RegPathList.Add("SOFTWARE\\WOW6432Node\\Microsoft\\Windows\\CurrentVersion\\Uninstall") | out-null
$RegPathList.Add("SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Uninstall") | out-null
foreach ($RegPath in $RegPathList)
{
	try
	{
		$RegObject = [microsoft.win32.registrykey]::OpenBaseKey([Microsoft.Win32.RegistryHive]::LocalMachine, [Microsoft.Win32.RegistryView]::Default)
		$RegKey = $RegObject.OpenSubKey($RegPath)
		foreach ($Software in $RegKey.GetSubKeyNames())
		{
			$SoftwarePath = "$RegPath\\$Software"
			$SoftwareObject = [microsoft.win32.registrykey]::OpenBaseKey([Microsoft.Win32.RegistryHive]::LocalMachine, [Microsoft.Win32.RegistryView]::Default)
			$SoftwareKey = $RegObject.OpenSubKey($SoftwarePath)
			if ($SoftwareKey.GetValue("DisplayName")) { $DisplayName = $SoftwareKey.GetValue("DisplayName") }
			else { $DisplayName = "Data Not Available" }
            if ($DisplayName -like "Computer Info") {
			    if ($SoftwareKey.GetValue("DisplayVersion")) { $Version = $SoftwareKey.GetValue("DisplayVersion") }
			    else { $Version = "0.0.0.0" }
			    if ($SoftwareKey.GetValue("Publisher")) { $Publisher = $SoftwareKey.GetValue("Publisher") }
			    else { $Publisher = "Data Not Available" }
			    $SoftwareObject = New-Object -TypeName PSObject
			    $SoftwareObject | Add-Member -MemberType NoteProperty -Name DisplayName -Value $DisplayName
			    $SoftwareObject | Add-Member -MemberType NoteProperty -Name Version -Value $Version
			    $SoftwareObject | Add-Member -MemberType NoteProperty -Name Publisher -Value $Publisher
                $SoftwareObject | Add-Member -MemberType NoteProperty -Name ObjectName -Value $SoftwareKey.Name.split("\")[$($SoftwareKey.Name.split("\").count - 1)]
			    if ($TotalSoftwareList -notcontains $DisplayName)
			    {
				    $TotalSoftware.Add($SoftwareObject) | Out-Null
			    }
			    $TotalSoftwareList.Add($DisplayName) | Out-Null
            }
		}
	}
	catch
	{
		# Nothing	
	}
}

# End running instances
Get-Process -Name 'Computer Info' -erroraction SilentlyContinue | Stop-Process -Force -erroraction SilentlyContinue
# Begin Installation
if ($(Install-AppMSI -MSIFile $AppInstallerFile) -eq $true) {
    if ($(Install-ComputerInfoLogo -CompanyLogoFile $LogoFile) -eq $true) {
        Log-Action -Message "Installation script finished successfully.  See details above."
    } else {
        Log-Action -Message "Warning: Installation of Computer Info finished successfully, however, the provided Company Logo file could not be copied and will not be displayed in the resulting installed application.  See details above."
    }
} else {
    Log-Action -Message "Script Finished Running. Installation encountered an error.  See details above."
}
